/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UGradient;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverRectangleG2d
implements UDriver<Graphics2D> {
    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke((float)uParam.getStroke().getThickness()));
        URectangle uRectangle = (URectangle)uShape;
        double d3 = uRectangle.getRx();
        double d4 = uRectangle.getRy();
        RectangularShape rectangularShape = d3 == 0.0 && d4 == 0.0 ? new Rectangle2D.Double(d, d2, uRectangle.getWidth(), uRectangle.getHeight()) : new RoundRectangle2D.Double(d, d2, uRectangle.getWidth(), uRectangle.getHeight(), d3, d4);
        UGradient uGradient = uParam.getGradient();
        if (uGradient == null) {
            if (uParam.getBackcolor() != null) {
                graphics2D.setColor(colorMapper.getMappedColor(uParam.getBackcolor()));
                DriverLineG2d.manageStroke(uParam, graphics2D);
                graphics2D.fill(rectangularShape);
            }
            if (uParam.getColor() != null) {
                graphics2D.setColor(colorMapper.getMappedColor(uParam.getColor()));
                graphics2D.draw(rectangularShape);
            }
        } else {
            GradientPaint gradientPaint = new GradientPaint((float)d, (float)d2, colorMapper.getMappedColor(uGradient.getColor1()), (float)(d + uRectangle.getWidth()), (float)(d2 + uRectangle.getHeight()), colorMapper.getMappedColor(uGradient.getColor2()));
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(rectangularShape);
        }
    }
}

